/*
 * Decompiled with CFR 0.152.
 */
package com.alexander.mutantmore.network;

import com.alexander.mutantmore.enums.CameraShakePriority;
import com.alexander.mutantmore.events.ShakeCameraEvent;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.NetworkEvent;

public class ServerToClientShakeCameraPacket {
    private final int duration;
    private final float amount;
    private final BlockPos causePos;
    private final int range;
    private final String priority;

    public ServerToClientShakeCameraPacket(int duration, float amount, BlockPos causePos, int range, String priority) {
        this.duration = duration;
        this.amount = amount;
        this.causePos = causePos;
        this.range = range;
        this.priority = priority;
    }

    public ServerToClientShakeCameraPacket(FriendlyByteBuf buf) {
        this.duration = buf.readInt();
        this.amount = buf.readFloat();
        this.causePos = buf.m_130135_();
        this.range = buf.readInt();
        this.priority = buf.m_130277_();
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.writeInt(this.duration);
        buf.writeFloat(this.amount);
        buf.m_130064_(this.causePos);
        buf.writeInt(this.range);
        buf.m_130070_(this.priority);
    }

    public boolean handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context ctx = supplier.get();
        ctx.enqueueWork(() -> ShakeCameraEvent.shake(null, this.duration, this.amount, this.causePos, this.range, CameraShakePriority.byName(this.priority)));
        return true;
    }
}

